#include <stdio.h>
#include "fxls8974.h"
#include "esp_log.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include <math.h>
#include "esp_sleep.h"
#include "driver/gpio.h"

static const char *TAG = "IMU";

// Update for your GPIOs
const gpio_num_t I2C_SDA = GPIO_NUM_7;
const gpio_num_t I2C_SCL = GPIO_NUM_6;
const gpio_num_t accelPin = GPIO_NUM_0;   // INT1 connect to ESP32 GPIO0
const gpio_num_t ledPin   = GPIO_NUM_4;   // LED

unsigned long delayTime = 1000;  // time between readings in millisec

volatile bool orientChange = false;

extern "C" {
void app_main(void)
{

    // Set up LED GPIO
    gpio_reset_pin(ledPin);    
    gpio_set_direction(ledPin, GPIO_MODE_OUTPUT);
    gpio_set_level(ledPin, 0);

    // Set up interrupt
    gpio_set_direction(accelPin, GPIO_MODE_INPUT);
    gpio_wakeup_enable(accelPin, GPIO_INTR_HIGH_LEVEL);  
    esp_err_t result = esp_sleep_enable_gpio_wakeup();
    if (result == ESP_OK) {
        ESP_LOGI(TAG, "GPIO Wake-Up set successfully.");
    } else {
        ESP_LOGW(TAG, "Failed to set GPIO Wake-Up as wake-up source.");
    }

    FXLS8974 imu;

    // Initialize IMU with I2C configuration
    if (!imu.begin(false, I2C_SCL, I2C_SDA)) {
        ESP_LOGE(TAG, "Failed to initialize FXLS8974");
        return;
    }

    // Proof of life!
    ESP_LOGI(TAG, "FXLS8974 Product ID: 0x%02X", imu.getProductID());
    
    // Set some acceleration parameters
    imu.orientEnableDbcn(1);
    imu.setorientDbCount(100);
    imu.orientEnable(1);
    imu.setOrientInterruptPin(0);    // INT1
    imu.OrientInterruptEnable(1);    
    imu.setMode(1);   
    vTaskDelay(pdMS_TO_TICKS(10));  //tiny delay needed
    
    OrientData orient;    // instantiate data structure

    while(1) {
      if (orientChange) {
        orientChange = 0;   // clear flag ASAP
        imu.getOrientation(orient);
        ESP_LOGI(TAG, "Orientation change detected!");
        ESP_LOGI(TAG, "New orientation: %s , %s , %s", 
                orient.LOString, orient.LAPOString, orient.BAFROString); 
      }

      ESP_LOGI(TAG, "Going to sleep...");
      esp_err_t err = esp_light_sleep_start();
      if (esp_sleep_get_wakeup_cause()==ESP_SLEEP_WAKEUP_GPIO)
        orientChange = 1;
      
      gpio_set_level(ledPin, 1);  
      vTaskDelay(pdMS_TO_TICKS(100));
      gpio_set_level(ledPin, 0);        
    }
}
}