#include <stdio.h>
#include <string> 
#include "freertos/FreeRTOS.h" // ESP32 RTOS
#include "freertos/task.h"
#include "freertos/event_groups.h"
#include "esp_random.h"
#include "6900_wifi.h"
#include "6900_http_client.h"


// SSID and credentials
// const char *ssid = "RLE";
// const char *pass = "";
const char *ssid = "EECS_Labs";
const char *pass = "";

static WiFi wifi;       // static (single, long-lived) WiFi instance
static http_client hc({.keep_alive = false});



extern "C" {
void app_main(void) {
    uint8_t count = 0;
    printf("Connecting to WiFi");
    wifi.begin(ssid,pass);
    while (wifi.status() != WIFI_STA_CONNECTED && count < 10) { //can change this to more attempts
        vTaskDelay(pdMS_TO_TICKS(1000));
        printf(".");
        count++;
    }
    if (wifi.isConnected()){
        printf("Connected!\n");
    }
    
    while (1) {
        std::string request_buffer = "https://en.wikipedia.org/api/rest_v1/page/summary/";
        request_buffer += std::to_string(esp_random() % 2025);
        
        std::string temp = "Sending GET request: " + request_buffer + "\n";
        printf("%s", temp.c_str());

        HttpResponse r = hc.http_request(request_buffer.c_str(),HTTP_METHOD_GET);
        printf("Response body:\n");
        if (r.err == ESP_OK && r.status >= 200 && r.status < 300) {
            printf("Response body:\n");
            if (hc.body_is_text()) printf("%s", hc.body_cstr());
            printf("\n");
        } else {
            printf("HTTP request failed\n");
        }
        vTaskDelay(pdMS_TO_TICKS(5000));
    }
}
}