/* High-level WiFi API using esp-idf framework
 * Exposes a few methods, more to write...
 * Assumes simplistic scenario: WiFi STA, WPA2 security via password
 */

#pragma once
#include "esp_event.h" // event loop handler library


#define WIFI_CONNECTED_BIT BIT0
#define WIFI_FAIL_BIT      BIT1
#define EXAMPLE_ESP_MAXIMUM_RETRY  5

// Simple public-facing status enum
typedef enum {
  WIFI_STA_STOP = 0,        // starting state, or when radio off
  WIFI_STA_CONNECTED_NO_IP, // STA started, associated w/ AP
  WIFI_STA_CONNECTED,       // STA started, associated with AP, has IP
  WIFI_STA_DISCONNECTED,    // STA started, not associated with AP
  WIFI_CONNECT_FAILED,      //
} wifi_status_t;

// Status bits, stolen/borrowed from Arduino WiFiGeneric class
static const int STA_STARTED_BIT   = BIT0;
static const int STA_CONNECTED_BIT = BIT1;
static const int STA_HAS_IP_BIT    = BIT2;


class WiFi {
public:
    wifi_status_t begin(const char *ssid, const char *passphrase = NULL);
    bool isConnected();
    static wifi_status_t status();
    wifi_status_t stop();
private:
    // this must be static to match types with esp-idf
    static void _wifi_event_handler(void* arg, esp_event_base_t event_base,
                                int32_t event_id, void* event_data);
    void _wifi_init_sta();
    
};
