/* Minimal HTTP Client for ESP-IDF, written in C++
 * For MIT 6.900
 * 
 * Joel Voldman
 * Created: Oct 2025
 */
#pragma once
#include "esp_system.h"
#include "esp_http_client.h"
#include <string>

#define MAX_HTTP_OUTPUT_BUFFER 2048     


struct HttpClientConfig {
    bool        keep_alive = false;       // default is to close after each connection
    uint32_t    idle_timeout_ms = 5000;   // close if idle > this
    uint32_t    req_timeout_ms  = 5000;   // esp_http_client timeout
};


struct HttpResponse {
    esp_err_t   err = ESP_FAIL;     // default is that we failed
    int         status = -1;        // response status code (e.g., 200, etc.)
};


class http_client {
public:
    http_client(const HttpClientConfig &cfg);
    ~http_client();
    HttpResponse http_request(const char *url, esp_http_client_method_t method, const void* body = nullptr, 
                int body_len = 0, const char* content_type = nullptr);
    int body_size();   
    const char* body_cstr();   
    const uint8_t* body_data();
    bool body_is_text();

private:
    HttpClientConfig _cfg;
    static esp_err_t _http_event_handler(esp_http_client_event_t *evt);

    esp_http_client_config_t _config{};   
    esp_http_client_handle_t _client{nullptr};
    bool _content_type_is_text(const char* ct);
    void _cleanup();
    char _local_response_buffer[MAX_HTTP_OUTPUT_BUFFER + 1]{};

};
